<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "participants_2020".
 *
 * @property int $id
 * @property string $name
 * @property string $mobile
 * @property string $chassis_number
 * @property int $fk_branch_id
 */
class Participants2020 extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'participants_2020';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'mobile', 'chassis_number', 'fk_branch_id'], 'required'],
            [['fk_branch_id'], 'integer'],
            [['name', 'mobile'], 'string', 'max' => 250],
            [['chassis_number'], 'string', 'max' => 350],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'mobile' => 'Mobile',
            'chassis_number' => 'Chassis Number',
            'fk_branch_id' => 'Fk Branch ID',
        ];
    }

    public function getBranch()
    {
        return $this->hasOne(Branches::className(), ['id', 'fk_branch_id']);
    }
}
