<?php

/* @var $this yii\web\View */
/* @var $form yii\bootstrap\ActiveForm */
/* @var $model \common\models\LoginForm */

use yii\helpers\Html;
use yii\bootstrap\ActiveForm;

$this->title = 'Login';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="login-box">
    <div class="login-logo">
        <a href="#">Admin</a>
    </div>
    <!-- /.login-logo -->
    <div class="login-box-body">

        <?php $form = ActiveForm::begin(['id' => 'login-form']); ?>
        <div class="form-group has-feedback">
            <?= $form->field($model, 'email')->textInput(['autofocus' => true,'placeholder'=>'Email','autocomplete' => 'off'])->label(false);?>
            <!-- <span class="glyphicon glyphicon-envelope form-control-feedback"></span>-->
        </div>
        <div class="form-group has-feedback">
            <?= $form->field($model, 'password')->passwordInput(['placeholder'=>'Password','autocomplete' => 'off'])->label(false); ?>
            <!-- <span class="glyphicon glyphicon-lock form-control-feedback"></span>-->
        </div>
        <div class="form-group has-feedback">
            <div class="col-xs-8">

                <?= $form->field($model, 'rememberMe')
                    ->checkbox(
                        ['template' => '
                        <div class="checkbox icheck">
                        <label>
                          {input}
                          {label}
                        </label>
                        </div>
                        ']
                    ); ?>


            </div>
        </div>
        <div class="row">


            <div class="col-xs-4">
                <?= Html::submitButton('Sign In', ['class' => 'btn btn-primary btn-block btn-flat', 'name' => 'login-button']) ?>

            </div>

        </div>
        <?php ActiveForm::end(); ?>

    </div>

</div>