<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "participants".
 *
 * @property int $id
 * @property string $account_number
 * @property string $name
 * @property string $mobile_no
 */
class Participants extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'participants';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['account_number', 'name', 'mobile_no'], 'safe'],
            [['account_number', 'name', 'mobile_no'], 'string', 'max' => 350],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'account_number' => 'Account Number',
            'name' => 'Name',
            'mobile_no' => 'Mobile No',
        ];
    }
}
