<?php
use yii\web\View;
use yii\helpers\Url;
use yii\widgets\ActiveForm;
/* @var $this yii\web\View */
$this->title ='Lucky Draw';
?>
<!-- Modal -->
<div
        class="modal fade result-modal"
        id="resultModal"
        tabindex="-1"
        aria-labelledby="resultModalLabel"
        aria-hidden="true"
>
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
                <div class="modal-result-cover">
                    <div
                            type="button"
                            class="modal-close"
                            data-dismiss="modal"
                            aria-label="Close"
                    >
                <span aria-hidden="true"
                ><img src="<?=Yii::$app->urlManager->baseUrl?>/files/images/close.svg" alt="Close"
                    /></span>
                    </div>
                    <div class="modal-result-hd">
                        <h3>Winner</h3>
                    </div>
                    <div class="modal-result-body">
                        <p id="winnername"></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<main class="content-sec">
      <div class="container-xl">
        <div class="row">
          <div class="col-12">
            <div class="lucky-wrapper">
              <div class="lucky-cover">
                <ul class="lucky-info">
                  <li class="lucky-item">
                    Total winners : <span class="item-value" id="currnt_qty" ><?=$prizes->type?></span>
                  </li>
                  <li class="lucky-item">
                    Remaining draws : <span class="item-value" id="available" ><?=$prizes->value?></span>
                  </li>
                </ul>
                <div class="lucky-draw">
                  <h1>Lucky Draw</h1>
                  <h3 id="headerNames"></h3>
                  <?php if($prizes->value>0){?>
                  <button class="btn btn-start" id="startButton" ><span class="btn-label">Start</span></button>
                  <?php }?>
                  <button class="btn btn-start" id="stopButton" style="display: none"><span class="btn-label">Stop</span></button>

                  <button id="winnerButton" class="btn btn-start" type="button" data-toggle="modal" data-target="#resultModal" style="display: none;">
                  <span class="btn-label">View Winner</span>
                  </button>
                  <div class="result-date" id="date-time" style="display: none;">
                            <p><span id="date-slot"></span> <span class="divider">|</span> <span id="time-slot"></span></p>

                            <div id="timerWrapper" style="display: none">Time left: <span id="timer"></span></div>

                            <div id="timesUp" style="display: none">
                        </div>
                    </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </main>

 
<?php
$url_finish=Yii::$app->urlManager->createUrl(['site/finish','id'=>$prizes->id]);
$url_to = Url::to(['site/index']);
$script = <<< JS
 $(document).ready(function() {
   var url_finish='$url_finish';
    $('#finishButton').click(function(e) {
        e.preventDefault();
      
        $.ajax({
            'url' : url_finish,
            'type' : 'POST',
            error: function() {
              
            },
            'success' : function(data) {
               if (data == "success") {
                  window.location.href = '$url_to';
               }
            }
        });
    });
});
JS;
$this->registerJs($script, View::POS_END);


?>

<?php if($type->value==0){?>

<?php
$url=Yii::$app->urlManager->createUrl(['site/update_file','id'=>$prizes->id]);
$script = <<< JS
"use strict";
var url_to='$url';
// Change to false if you don't want a timer
var showTimer = false;

// Set timer countdown time here in minutes : seconds format
var time = 0 + ":" + 19;

// Add list of names here
var namesList =$list;


// Default variables
var i = 0;
var x = 0;
var intervalHandle = null;
var startButton = document.getElementById('startButton');
var stopButton = document.getElementById('stopButton');
var winnerButton = document.getElementById('winnerButton');
var finishButton = document.getElementById('finishButton');
var headerOne = document.getElementById('headerNames');
var timesUp = document.getElementById('timesUp');
var timerWrapper = document.getElementById('timerWrapper');
var timer = document.getElementById('timer');
var dateTimediv = document.getElementById('date-time');

// Optional countdown timer
// Add zero in front of numbers < 10
function checkSecond(sec) {
	if (sec < 10 && sec >= 0) {
		sec = "0" + sec;
	}
	if (sec < 0) {
		sec = "59";
	}
	return sec;
}

var startTimer = function startTimer() {
	var presentTime = timer.innerHTML;
	var timeArray = presentTime.split(/[:]+/);
	var m = timeArray[0];
	var s = checkSecond(timeArray[1] - 1);

	if (s == 59) {
		m = m - 1;
	}
	/*if (m < 0) {
		timesUp.style.display = "block";
	}*/

	timer.innerHTML = m + ":" + s;

	setTimeout(startTimer, 1000);
};

// Start or stop the name shuffle on button click
startButton.addEventListener('click', function () {
	this.style.display = "none";
	stopButton.style.display = "block";
	intervalHandle = setInterval(function () {
		headerNames.innerHTML = namesList[i++ % namesList.length];
	}, 20);
	if (showTimer === true) {
		timerWrapper.classList.remove('visible');
	}
});
stopButton.addEventListener('click', function () {
	this.style.display = "none";
	startButton.style.display = "block";
	winnerButton.style.display = "block";
	//finishButton.style.display = "block";
	dateTimediv.style.display = "block";
	clearInterval(intervalHandle);
	timer.innerHTML = time;
	if (showTimer === true) {
		timerWrapper.classList.add('visible');
	}
	document.getElementById("winnername").innerHTML = headerOne.innerHTML;
	var today = new Date();
    var dd = today.getDate();
    var mm = today.getMonth() + 1; //January is 0!
    var yyyy = today.getFullYear();
    
    if (dd < 10) {
      dd = '0' + dd;
    }
    
    if (mm < 10) {
      mm = '0' + mm;
    }
    document.getElementById("date-slot").innerHTML=mm + '/' + dd + '/' + yyyy;
    
    var timenow = new Date();
    document.getElementById("time-slot").innerHTML=timenow.getHours() + ":" + timenow.getMinutes() + ":" + timenow.getSeconds();
    var dataToSend = {'text':headerOne.textContent};
      $.ajax({
        url: url_to,
        type: 'post',
        data: dataToSend,
        success: function(data) {
            var jsondata = JSON.parse(data);
            $('#currnt_qty').text(jsondata.winner);
            $('#available').text(jsondata.avilable);

            if(jsondata.avilable==0){
              $("#startButton").hide();
            }
            if(jsondata.avilable==0){
                $("#finishButton").css("display", "block");
            }
            
        },
         
    });
	
	startTimer();
});

// Allow use of spacebar to start/stop name shuffle
document.body.onkeyup = function (e) {
	if (e.keyCode == 32) {
		if (x % 2 === 0) {
			startButton.style.display = "none";
			stopButton.style.display = "block";
			intervalHandle = setInterval(function () {
				headerNames.innerHTML = namesList[i++ % namesList.length];
			}, 50);
			if (showTimer === true) {
				timerWrapper.classList.remove('visible');
			}
		} else {
			startButton.style.display = "block";
			stopButton.style.display = "none";
			clearInterval(intervalHandle);
			timer.innerHTML = time;
			if (showTimer === true) {
				timerWrapper.classList.add('visible');
			}
			startTimer();
		}
		x++;
	}
};

// Blinking warning
var backgroundInterval = setInterval(function () {
	timesUp.classList.toggle("backgroundRed");
}, 1000);


// Get the modal
var modal = document.getElementById('myModal');

// Get the button that opens the modal
var btn = document.getElementById("winnerButton");

// Get the <span> element that closes the modal
var span = document.getElementsByClassName("close")[0];

// When the user clicks on the button, open the modal 
btn.onclick = function() {
  modal.style.display = "block";
}

// When the user clicks on <span> (x), close the modal
span.onclick = function() {
  modal.style.display = "none";
  location.reload(true);
}

// When the user clicks anywhere outside of the modal, close it
window.onclick = function(event) {
  if (event.target == modal) {
    modal.style.display = "none";
  }
}

JS;
    $this->registerJs($script, View::POS_END);
    ?>

<?php }else{?>

<?php
$url=Yii::$app->urlManager->createUrl(['site/update_file','id'=>$prizes->id]);
$script = <<< JS
"use strict";
var url_to='$url';

// Change to false if you don't want a timer
var showTimer = false;

// Set timer countdown time here in minutes : seconds format
var time = 0 + ":" + 19;

// Add list of names here
var namesList =$list;


// Default variables
var i = 0;
var x = 0;
var intervalHandle = null;
var startButton = document.getElementById('startButton');
var stopButton = document.getElementById('stopButton');
var winnerButton = document.getElementById('winnerButton');
var finishButton = document.getElementById('finishButton');
var dateTimediv = document.getElementById('date-time');
var headerOne = document.getElementById('headerNames');
var timesUp = document.getElementById('timesUp');
var timerWrapper = document.getElementById('timerWrapper');
var timer = document.getElementById('timer');

// Optional countdown timer
// Add zero in front of numbers < 10
function checkSecond(sec) {
	if (sec < 10 && sec >= 0) {
		sec = "0" + sec;
	}
	if (sec < 0) {
		sec = "59";
	}
	return sec;
}

var startTimer = function startTimer() {
	var presentTime = timer.innerHTML;
	var timeArray = presentTime.split(/[:]+/);
	var m = timeArray[0];
	var s = checkSecond(timeArray[1] - 1);

	if (s == 59) {
		m = m - 1;
	}
	/*if (m < 0) {
		timesUp.style.display = "block";
	}*/

	timer.innerHTML = m + ":" + s;

	setTimeout(startTimer, 1000);
};

// Start or stop the name shuffle on button click
startButton.addEventListener('click', function () {
	this.style.display = "none";
	stopButton.style.display = "block";
	intervalHandle = setInterval(function () {
		headerNames.textContent = namesList[i++ % namesList.length];
	}, 20);
	if (showTimer === true) {
		timerWrapper.classList.remove('visible');
	}
	setTimeout('stopButton.click()', $modelTime);
});
stopButton.addEventListener('click', function () {
	this.style.display = "none";
	startButton.style.display = "block";
	winnerButton.style.display = "block";
//	finishButton.style.display = "block";
	dateTimediv.style.display = "block";
	clearInterval(intervalHandle);
	timer.innerHTML = time;
	if (showTimer === true) {
		timerWrapper.classList.add('visible');
	}
	document.getElementById("winnername").innerHTML = headerOne.textContent;
	var today = new Date();
    var dd = today.getDate();
    var mm = today.getMonth() + 1; //January is 0!
    var yyyy = today.getFullYear();
    
    if (dd < 10) {
      dd = '0' + dd;
    }
    
    if (mm < 10) {
      mm = '0' + mm;
    }
    document.getElementById("date-slot").innerHTML=mm + '/' + dd + '/' + yyyy;
	 var timenow = new Date();
    document.getElementById("time-slot").innerHTML=timenow.getHours() + ":" + timenow.getMinutes() + ":" + timenow.getSeconds();
    
      $.ajax({
        url: url_to,
        type: 'post',
        data: {'text':headerOne.textContent},
        success: function(data) {
                
        },
         
        });
	
	startTimer();
});

// Allow use of spacebar to start/stop name shuffle
document.body.onkeyup = function (e) {
	if (e.keyCode == 32) {
		if (x % 2 === 0) {
			startButton.style.display = "none";
			stopButton.style.display = "block";
			intervalHandle = setInterval(function () {
				headerNames.textContent = namesList[i++ % namesList.length];
			}, 50);
			if (showTimer === true) {
				timerWrapper.classList.remove('visible');
			}
		} else {
			startButton.style.display = "block";
			stopButton.style.display = "none";
			clearInterval(intervalHandle);
			timer.innerHTML = time;
			if (showTimer === true) {
				timerWrapper.classList.add('visible');
			}
			startTimer();
		}
		x++;
	}
};

// Blinking warning
var backgroundInterval = setInterval(function () {
	timesUp.classList.toggle("backgroundRed");
}, 1000);


// Get the modal
var modal = document.getElementById('myModal');

// Get the button that opens the modal
var btn = document.getElementById("winnerButton");

// Get the <span> element that closes the modal
var span = document.getElementsByClassName("close")[0];

// When the user clicks on the button, open the modal 
btn.onclick = function() {
  modal.style.display = "block";
}

// When the user clicks on <span> (x), close the modal
span.onclick = function() {
  modal.style.display = "none";
  location.reload(true);
}

// When the user clicks anywhere outside of the modal, close it
window.onclick = function(event) {
  if (event.target == modal) {
    modal.style.display = "none";
  }
}

JS;
    $this->registerJs($script, View::POS_END);
    ?>

<?php }?>
