<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "participants".
 *
 * @property int $id
 * @property string|null $email
 * @property string|null $uuid
 * @property string|null $contact
 * @property string|null $country
 * @property string|null $name
 * @property string|null $prizes
 * @property string|null $purchase_receipt
 * @property string|null $user_language
 * @property string|null $date_time
 * @property string|null $source_sheet
 */
class Participants2025 extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'participants';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['date_time','winner'], 'safe'],
            [['prizes'], 'safe'],
            [['email', 'uuid', 'contact', 'country', 'name', 'purchase_receipt', 'user_language', 'source_sheet'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id'              => 'ID',
            'email'           => 'Email',
            'uuid'            => 'UUID',
            'contact'         => 'Contact',
            'country'         => 'Country',
            'name'            => 'Name',
            'prizes'          => 'Prizes',
            'purchase_receipt'=> 'Purchase Receipt',
            'user_language'   => 'User Language',
            'date_time'       => 'Date & Time',
            'source_sheet'    => 'Source Sheet',
        ];
    }
}
