<?php

namespace backend\controllers;

use Yii;
use common\models\Participants2025;
use common\models\Participants2025Search;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use backend\models\ImportForm;
use PhpOffice\PhpSpreadsheet\IOFactory;

/**
 * Participants2025Controller implements the CRUD actions for Participants2025 model.
 */
class Participants2025Controller extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Participants2025 models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new Participants2025Search();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
    
public function actionImport()
{
    $model = new ImportForm();

    if (Yii::$app->request->isPost) {
        $model->excelFile = UploadedFile::getInstance($model, 'excelFile');
        if ($model->validate()) {
            $path = Yii::getAlias('@webroot') . '/uploads/';
            if (!file_exists($path)) {
                mkdir($path, 0777, true);
            }

            $filePath = $path . time() . '_' . $model->excelFile->name;
            $model->excelFile->saveAs($filePath);

            // Load Excel file
            $spreadsheet = IOFactory::load($filePath);

            // Helper: remove emojis
            $removeEmojis = function ($string) {
                return preg_replace(
                    '/[\x{1F600}-\x{1F64F}]|' .  // emoticons
                    '[\x{1F300}-\x{1F5FF}]|' .  // symbols & pictographs
                    '[\x{1F680}-\x{1F6FF}]|' .  // transport & map
                    '[\x{2600}-\x{26FF}]|'   .  // misc symbols
                    '[\x{2700}-\x{27BF}]|'   .  // dingbats
                    '[\x{1F900}-\x{1F9FF}]|' .  // supplemental symbols
                    '[\x{1F1E6}-\x{1F1FF}]/u', // flags
                    '',
                    $string
                );
            };

            foreach ($spreadsheet->getSheetNames() as $sheetIndex => $sheetName) {
                $sheet = $spreadsheet->getSheet($sheetIndex);
                $rows = $sheet->toArray();

                foreach ($rows as $i => $row) {
                    if ($i == 0) continue; // skip header row

                    // skip if entire row is empty
                    if (empty(array_filter($row))) {
                        continue;
                    }

                    // sanitize inputs
                    $email     = !empty($row[0]) ? trim((string)$row[0]) : null;
                    $uuid      = !empty($row[1]) ? trim((string)$row[1]) : null;
                    $contact   = !empty($row[2]) ? trim((string)$row[2]) : null;
                    $country   = !empty($row[3]) ? trim((string)$row[3]) : null;
                    $name      = !empty($row[4]) ? $removeEmojis(trim((string)$row[4])) : null;
                    $prizes    = !empty($row[5]) ? trim((string)$row[5]) : null;
                    $receipt   = !empty($row[6]) ? trim((string)$row[6]) : null;
                    $language  = !empty($row[7]) ? trim((string)$row[7]) : null;

                    $date = null;
                    if (!empty($row[8])) {
                        $time = strtotime($row[8]);
                        if ($time !== false) {
                            $date = date('Y-m-d H:i:s', $time);
                        }
                    }

                    // insert only if at least one important field has data
                    if ($email || $uuid || $contact || $country || $name) {
                        Yii::$app->db->createCommand()->insert('participants', [
                            'email'            => $email,
                            'uuid'             => $uuid,
                            'contact'          => $contact,
                            'country'          => $country,
                            'name'             => $name,
                            'prizes'           => $prizes,
                            'purchase_receipt' => $receipt,
                            'user_language'    => $language,
                            'date_time'        => $date,
                            'source_sheet'     => $sheetName,
                        ])->execute();
                    }
                }
            }

            Yii::$app->session->setFlash('success', 'Excel Imported Successfully!');
            return $this->refresh();
        }
    }

    return $this->render('import', ['model' => $model]);
}


    /**
     * Displays a single Participants2025 model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Participants2025 model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Participants2025();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Participants2025 model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Participants2025 model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Participants2025 model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Participants2025 the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Participants2025::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
