<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\Participants2025Search */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Participants';
$this->params['breadcrumbs'][] = $this->title;
?>
    <section class="content">
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
               
                <!-- /.box-header -->
                <div class="box-body pad">
                <?php echo $this->render('_search', ['model' => $searchModel]); ?>
                </div>
                <div class="box-body pad">

                    <?= GridView::widget([
                        'dataProvider' => $dataProvider,
                       // 'filterModel' => $searchModel,
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],

                            'name',
                            'mobile',
                            'quantity',
                            'status',
                            //'recipt_image',
                            'created_at',

                        [
                            'class' => 'yii\grid\ActionColumn',
                            'template' => '{view} {update}',
                            'buttons' => [
                                'view' => function ($url, $model, $key) {
                                    return Html::a('View', $url, ['class' => 'btn btn-primary']);
                                },
                                'update' => function ($url, $model, $key) {
                                    return Html::a('Update', $url, ['class' => 'btn btn-warning']);
                                },
                            ],
                        ],
                        ],
                    ]); ?>

                </div>
            </div>
        </div>
    </div>
    </section>
