<?php

use yii\helpers\Html;
use dosamigos\ckeditor\CKEditor;
use yii\widgets\ActiveForm;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $model common\models\Cms */

$this->title = 'Banners';
//$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Album'), 'url' => ['cms/album']];
$this->params['breadcrumbs'][] = $this->title;
?>
<style>
    .thumb {
        min-height: 200px!important;
    }
</style>
<!-- Main content -->
<section class="content">
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><?=$this->title?></h3>
                </div>
                <!-- /.box-header -->
                <div class="box-body pad">
                    <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>
                    <?= $form->field($model, 'slider_content')->widget(CKEditor::className(), [
                        'preset' => 'full',
                        'clientOptions' => [
                            'height' => 150,
                            'filebrowserUploadUrl' => Yii::$app->urlManager->createUrl(['cms/uploadimage']),
                            'allowedContent' => true,
                            'extraPlugins'=>'iframe'
                        ]
                    ]) ?>
                    <?= $form->field($model, 'slider_content_ar')->widget(CKEditor::className(), [
                        'preset' => 'full',
                        'clientOptions' => [
                            'height' => 150,
                            'allowedContent' => true,
                            'ContentLangDirection'=>'rtl',
                            'filebrowserUploadUrl' => Yii::$app->urlManager->createUrl(['cms/uploadimage']),
                            'language'=>'ar',
                            'extraPlugins'=>'iframe'
                        ]
                    ]) ?>
                    <?= $form->field($model, 'slider_order')->textInput()->label('Sort Order'); ?>

                    <?= $form->field($model, 'slider_image')->fileInput()->label('Image(1366x651)')?>

                    <?php if(!$model->isNewRecord):
                        echo Html::img(Yii::$app->urlManagerfrontend->baseUrl.'/uploads/'.$model->slider_image,['class' => 'img-responsive img-thumbnail','width'=>100]) ;
                        echo Html::activeHiddenInput($model, 'slider_image');
                    endif;
                    ?>
                    <?php echo $form->field($model, 'status')->dropDownList(['Publish' => 'Publish','Hide'=>'Hide']); ?>
                    <div class="form-group">
                        <?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Add') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>

                <div class="box-body pad">
                    <div class="row">
                        <?php
                        if($banners){
                            foreach($banners as $banner){
                                ?>
                                <div class="col-lg-3 col-md-4 col-xs-6 thumb">
                                    <a class="thumbnail" href="#">
                                        <img class="img-responsive" src="<?php echo Yii::$app->urlManagerfrontend->baseUrl.'/uploads/'.$banner->slider_image?>" alt="">
                                    </a>
                                    <div class="text-center">
                                        <?= Html::a('<i class="fa fa-pencil"></i>', ['slider', 'id' =>$banner->slider_id], [
                                            'class'=>'btn btn-success btn-xs',

                                        ]) ?>
                                        <?= Html::a('<i class="fa fa-trash-o"></i>', ['sliderdelete', 'id' =>$banner->slider_id], [
                                            'class'=>'btn btn-danger btn-xs',
                                            'onclick'=>"return confirm('Are you sure?')",
                                            'data' => [
                                                'confirm' => 'Are you sure you want to delete this image?',
                                                'method' => 'post',
                                            ],

                                        ]) ?>
                                    </div>
                                </div>
                            <?php }}?>
                    </div>
                </div>
                <!-- /.box -->

            </div>
        </div>
</section>