<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\web\View;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $model common\models\Company */
/* @var $form yii\widgets\ActiveForm */

$this->title = 'Update User';
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add Users'), 'url' => ['Users']];
$this->params['breadcrumbs'][] = $this->title;
?>
<section class="content">
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><?=$this->title?></h3>
                </div>
                <!-- /.box-header -->
                <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>

                <div class="box-body">

                    <?=$form->field($model, 'name')->textInput(['maxlength' => true]) ?>

                    <?=$form->field($model, 'username')->textInput(['maxlength' => true]) ?>

                    <?= $form->field($model, 'email') ?>



                    <div class="box-footer">
                        <?= Html::submitButton('Update', ['class' =>'btn btn-success']) ?>
                    </div>
                </div>

                <?php ActiveForm::end(); ?>

            </div>
            <!-- /.box -->

        </div>
        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Change Password</h3>
                </div>
                <!-- /.box-header -->
                <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>

                <div class="box-body">

                    <?= $form->field($modelResetpassword, 'newpass')->passwordInput(['placeholder'=>'New Password'])->label(false); ?>
                    <?= $form->field($modelResetpassword, 'repeatPassword')->passwordInput(['placeholder'=>'Repeat Password'])->label(false); ?>

                    <div class="box-footer">
                        <?= Html::submitButton('Update', ['class' =>'btn btn-success']) ?>
                    </div>
                </div>

                <?php ActiveForm::end(); ?>

            </div>
            <!-- /.box -->

        </div>

    </div>
</section>


