<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\web\View;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $model common\models\Company */
/* @var $form yii\widgets\ActiveForm */

$this->title = 'Add Promtor';

$this->params['breadcrumbs'][] = $this->title;
?>
<section class="content">
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><?=$this->title?></h3>
                </div>
                <!-- /.box-header -->
                <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>

                <div class="box-body">

                    <?=$form->field($model, 'name')->textInput(['maxlength' => true]) ?>

                    <?= $form->field($model, 'email') ?>

                    <?= $form->field($model, 'password')->passwordInput() ?>
                    <?= $form->field($model, 'confirm_password')->passwordInput() ?>

                    <div class="box-footer">
                        <?= Html::submitButton('Submit', ['class' =>'btn btn-success']) ?>
                    </div>
                </div>

                <?php ActiveForm::end(); ?>

            </div>
            <!-- /.box -->

        </div>
        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Manage Promotors</h3>
                </div>
                <!-- /.box-header -->
                <div class="box-body">
                <?= GridView::widget([
                    'dataProvider' => $provider,
                    'columns' => [
                        ['class' => 'yii\grid\SerialColumn'],
                        'name',
                        'username',
                        'email',
                       /* [
                            'label'=>'Assign Permissions',
                            'format'=>'raw',
                            'value' => function($data){
                                return
                                    Html::a('<i class="fa fa-plus-circle" aria-hidden="true"></i> Assign Permission', ['/admin/assignment/view','id'=>$data->id], ['title' => 'Permission']);
                            }
                        ],*/
                        [
                            'format'=>'raw',
                            'value' => function($data){
                                return
                                    Html::a('<span class="glyphicon glyphicon-pencil"></span>', ['/settings/userupdate','id'=>$data->id], ['title' => 'edit']).' '.
                                    Html::a('<span class="glyphicon glyphicon-trash"></span>', ['/settings/deleteuser', 'id' => $data->id], [
                                        'class' => '',
                                        'onclick'=>"return confirm('Are you sure?')",
                                        'data' => [
                                            'confirm' => 'Are you sure you want to delete this item?',
                                            'method' => 'post',
                                        ],
                                    ]);
                            }
                        ],

                    ],
                ]); ?>

                </div>

            </div>
            <!-- /.box -->

        </div>
    </div>
</section>


