<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\ParticipantsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Participants';
$this->params['breadcrumbs'][] = $this->title;
?>
<section class="content">
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><?=$this->title?></h3>
                    <div class="pull-right box-tools">
                        <?php echo Html::a('Delete All ', ['deleteall'], ['class' => 'btn btn-danger']) ?>
                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body pad">
                    <?php echo $this->render('_import', ['import' => $import]); ?>
                    <hr>
                    <?= GridView::widget([
                        'dataProvider' => $dataProvider,
                        'filterModel' => $searchModel,
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],

                            'account_number',
                            'name',
                            'mobile_no',

                            ['class' => 'yii\grid\ActionColumn','template'=>'{delete}'],
                        ],
                    ]); ?>
                </div>
            </div>
        </div>
    </div>
</section>
