<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
/* @var $this yii\web\View */
/* @var $searchModel common\models\BranchesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Branches';
$this->params['breadcrumbs'][] = $this->title;
?>
<section class="content">
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><?=$this->title?></h3>

                </div>
                <!-- /.box-header -->
                <div class="box-body pad">

                    <?php $form = ActiveForm::begin(); ?>

                    <?= $form->field($model, 'branch_name')->textInput() ?>
                    <?php
                    echo $form->field($model, 'draw_status')->dropDownList(
                        ['1' => 'Active', '0' => 'Disabled']
                    ); ?>
                    <div class="form-group">
                        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>

                </div>
            </div>
        </div>


        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><?=$this->title?></h3>

                </div>
                <!-- /.box-header -->
                <div class="box-body pad">

                    <?= GridView::widget([
                        'dataProvider' => $dataProvider,
                        //  'filterModel' => $searchModel,
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],

                            'branch_name',
                            [
                                'format'=>'raw',
                                'value' => function($data){

                                        $button=html::a(' Manage Participants', ['/participants/index','id'=>$data->id], ['title' => 'Manage','class'=>'btn btn-sm btn-danger','target'=>'_blank']);

                                    return $button;
                                }
                            ],
                            [
                                'label'=>'Draw Status',
                                'format'=>'raw',
                                'value' => function($data){
                                    $status='';
                                    if($data->draw_status==1){
                                        $status='Active';
                                    }else{
                                        $status='Disabled ';
                                    }
                                    return $status;
                                }
                            ],

                            ['class' => 'yii\grid\ActionColumn','template'=>'{update} {delete}','buttons' => [

                                'update' => function ($url, $model) {
                                    return Html::a('<span class="glyphicon glyphicon-pencil"></span>', ['branches/index','id'=>$model->id], [
                                        'title' => Yii::t('app', 'update'),
                                    ]);
                                },

                            ],],
                        ],
                    ]); ?>

                </div>
            </div>
        </div>
    </div>
</section>
