/*!
 * @package   yii2-grid
 * @author    Kartik Visweswaran <kartikv2@gmail.com>
 * @copyright Copyright &copy; Kartik Visweswaran, Krajee.com, 2014 - 2018
 * @version   3.2.1
 *
 * Grid Export Validation Module for Yii's Gridview. Supports export of
 * grid data as CSV, HTML, or Excel.
 *
 * Author: Kartik Visweswaran
 * Copyright: 2014 - 2018, Kartik Visweswaran, Krajee.com
 * For more JQuery plugins visit http://plugins.krajee.com
 * For more Yii related demos visit http://demos.krajee.com
 */
!function(t){"use strict";var e,o,i,n,r,s,a="urn:schemas-microsoft-com:office:";e=function(t,e,o){return t.split(e).join(o)},o=function(e,o){return null==e||0===e.length||o&&""===t.trim(e)},i=function(t,e,o,i){var n=screen.width/2-o/2;return window.open("",e,"",!0).close(),window.open(t,e,"toolbar=no, location=no, directories=no, status=yes, menubar=no, scrollbars=no, resizable=no, copyhistory=no, width="+o+", height="+i+", top=60, left="+n)},n=function(t){return t.toLowerCase().replace(/[^\w ]+/g,"").replace(/ +/g,"-")},r={html:'<!DOCTYPE html><meta http-equiv="Content-Type" content="text/html;charset={encoding}"/><meta http-equiv="X-UA-Compatible" content="IE=edge;chrome=1"/>{css}<style>.kv-wrap{padding:20px;}.kv-align-center{text-align:center;}.kv-align-left{text-align:left;}.kv-align-right{text-align:right;}.kv-align-top{vertical-align:top!important;}.kv-align-bottom{vertical-align:bottom!important;}.kv-align-middle{vertical-align:middle!important;}.kv-page-summary{border-top:4px double #ddd;font-weight: bold;}.kv-table-footer{border-top:4px double #ddd;font-weight: bold;}.kv-table-caption{font-size:1.5em;padding:8px;border:1px solid #ddd;border-bottom:none;}</style><body class="kv-wrap">{data}</body>',pdf:"{before}\n{data}\n{after}",excel:'<html xmlns:o="'+a+'office" xmlns:x="'+a+'excel" xmlns="http://www.w3.org/TR/REC-html40"><head><meta http-equiv="Content-Type" content="text/html;charset={encoding}"/>{css}\x3c!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--\x3e</head><body>{data}</body></html>',popup:'<html style="display:table;width:100%;height:100%;"><title>Grid Export - &copy; Krajee</title><body style="display:table-cell;font-family:Helvetica,Arial,sans-serif;color:#888;font-weight:bold;line-height:1.4em;text-align:center;vertical-align:middle;width:100%;height:100%;padding:0 10px;">{msg}</body></html>'},(s=function(e,o){var i=o.gridOpts,n=o.genOpts;this.$element=t(e),this.gridId=i.gridId,this.$grid=t("#"+i.gridId),this.dialogLib=o.dialogLib,this.messages=i.messages,this.target=i.target,this.exportConversions=i.exportConversions,this.showConfirmAlert=i.showConfirmAlert,this.filename=n.filename,this.expHash=n.expHash,this.showHeader=n.showHeader,this.showFooter=n.showFooter,this.showPageSummary=n.showPageSummary,this.$table=this.$grid.find(".kv-grid-table:first"),this.$form=this.$grid.find("form.kv-export-form"),this.encoding=this.$form.find('[name="export_encoding"]').val(),this.columns=this.showHeader?"td,th":"td",this.alertMsg=o.alertMsg,this.config=o.config,this.popup="",this.listen()}).prototype={constructor:s,getArray:function(e){var i=this,r=i.clean(e),s=[],a={};return void 0!==i.config.colHeads&&i.config.colHeads.length>0?s=i.config.colHeads:r.find("thead tr th").each(function(e){var r=t(this).text().trim(),a=n(r);s[e]=!i.config.slugColHeads||o(a)?"col_"+e:a}),r.find('tbody tr:has("td")').each(function(e){a[e]={},t(this).children("td").each(function(o){var i=s[o];a[e][i]=t(this).text().trim()})}),a},setPopupAlert:function(t){if(void 0!==this.popup.document)if(arguments.length&&arguments[1]){var e=this.popup.document.getElementsByTagName("body");setTimeout(function(){e[0].innerHTML=t},4e3)}else{var o=r.popup.replace("{msg}",t);this.popup.document.write(o)}},processExport:function(t,e){var i=this;setTimeout(function(){o(e)?i[t]():i[t](e)},100)},listenClick:function(t){var e=this,i=arguments.length>1?arguments[1]:"",n=window[e.dialogLib];e.$element.off("click.gridexport").on("click.gridexport",function(r){if(r.stopPropagation(),r.preventDefault(),e.showConfirmAlert){var s=e.messages,a=o(e.alertMsg)?"":e.alertMsg,l=o(s.allowPopups)?"":s.allowPopups,c=o(s.confirmDownload)?"":s.confirmDownload,h="";if(h=a.length&&l.length?a+"\n\n"+l:!a.length&&l.length?l:a.length&&!l.length?a:"",c.length&&(h=h+"\n\n"+c),!o(h))return n.confirm(h,function(o){o&&e.processExport(t,i),r.preventDefault()}),!1}else e.processExport(t,i)})},listen:function(){var t=this;"_popup"===t.target&&t.$form.on("submit.gridexport",function(){setTimeout(function(){t.setPopupAlert(t.messages.downloadComplete,!0)},1e3)}),t.$element.hasClass("export-csv")&&t.listenClick("exportTEXT","csv"),t.$element.hasClass("export-txt")&&t.listenClick("exportTEXT","txt"),t.$element.hasClass("export-html")&&t.listenClick("exportHTML"),t.$element.hasClass("export-xls")&&t.listenClick("exportEXCEL"),t.$element.hasClass("export-json")&&t.listenClick("exportJSON"),t.$element.hasClass("export-pdf")&&t.listenClick("exportPDF")},clean:function(e){var o,i=this,n=i.$table.clone(),r=i.$table.closest(".kv-grid-container"),s=function(t){n.find(t+"."+i.gridId).remove()};(o=r.hasClass("kv-grid-wrapper")?r.closest(".floatThead-wrapper").find(".kv-thead-float thead"):r.find(".kv-thead-float thead")).length&&(o=o.clone(),n.find("thead").before(o).remove()),n.find("tr.filters").remove(),n.find("th").removeAttr("rowspan"),n.find("th").find("a").each(function(){t(this).contents().unwrap()}),n.find("input").remove(),i.showHeader||n.children("thead").remove(),i.showPageSummary||s(".kv-page-summary-container"),i.showFooter||s(".kv-footer-container"),i.showCaption||s(".kv-caption-container"),n.find(".skip-export").remove(),n.find(".skip-export-"+e).remove(),n.find(".strip-tags-export").each(function(){var e=t(this),o=e.text();e.html(o)});var a=n.html();return a=i.preProcess(a),n.html(a),n},preProcess:function(t){var o,i=this.exportConversions,n=i.length,r=t;if(n>0)for(var s=0;s<n;s++)o=i[s],r=e(r,o.from,o.to);return r},download:function(t,e){var n=this,r=n.$element,s=r.attr("data-mime")||"text/plain",a=r.attr("data-hash")||"",l=o(n.config)?{}:n.config,c=function(t,e){n.$form.find('[name="export_'+t+'"]').val(e)};"json"===t&&l.jsonReplacer&&delete l.jsonReplacer,c("filetype",t),c("filename",n.filename),c("content",e),c("mime",s),c("hash",a),c("config",JSON.stringify(l)),"_popup"===n.target&&(n.popup=i("","kvDownloadDialog",350,120),n.popup.focus(),n.setPopupAlert(n.messages.downloadProgress)),n.$form.submit()},exportHTML:function(){var e=this.clean("html"),o=this.config,i=this.config.cssFile&&o.cssFile.length?'<link href="'+this.config.cssFile+'" rel="stylesheet">':"",n=r.html.replace("{encoding}",this.encoding).replace("{css}",i).replace("{data}",t("<div />").html(e).html());this.download("html",n)},exportPDF:function(){var e=this.clean("pdf"),i=o(this.config.contentBefore)?"":this.config.contentBefore,n=o(this.config.contentAfter)?"":this.config.contentAfter,s=this.config.css,a=r.pdf.replace("{css}",s).replace("{before}",i).replace("{after}",n).replace("{data}",t("<div />").html(e).html());this.download("pdf",a)},exportTEXT:function(e){var o=this,i=o.clean(e).find("tr:has("+o.columns+")"),n=String.fromCharCode(11),r=String.fromCharCode(0),s='"'+o.config.colDelimiter+'"',a='"'+o.config.rowDelimiter+'"',l='"'+i.map(function(e,i){return t(i).find(o.columns).map(function(e,o){return t(o).text().trim().replace(/"/g,'""')}).get().join(n)}).get().join(r).split(r).join(a).split(n).join(s)+'"';o.download(e,l)},exportJSON:function(){var t=this.getArray("json");t=JSON.stringify(t,this.config.jsonReplacer,this.config.indentSpace),this.download("json",t)},exportEXCEL:function(){var e,o,i=this.clean("xls"),n=this.config.cssFile&&this.config.cssFile.length?'<link href="'+this.config.cssFile+'" rel="stylesheet">':"";i.find("td[data-raw-value]").each(function(){((o=t(this)).css("mso-number-format")||0===o.css("mso-number-format")||"0"===o.css("mso-number-format"))&&o.html(o.attr("data-raw-value")).removeAttr("data-raw-value")}),e=r.excel.replace("{encoding}",this.encoding).replace("{css}",n).replace("{worksheet}",this.config.worksheet).replace("{data}",t("<div />").html(i).html()).replace(/"/g,"'"),this.download("xls",e)}},t.fn.gridexport=function(e){var o=Array.apply(null,arguments);return o.shift(),this.each(function(){var i=t(this),n=i.data("gridexport"),r="object"==typeof e&&e;n||i.data("gridexport",n=new s(this,t.extend({},t.fn.gridexport.defaults,r,t(this).data()))),"string"==typeof e&&n[e].apply(n,o)})},t.fn.gridexport.defaults={dialogLib:"krajeeDialog"},t.fn.gridexport.Constructor=s}(window.jQuery);