<?php



namespace frontend\models;



use Yii;

use yii\base\Model;



/**

 * ContactForm is the model behind the contact form.

 */

class ContactForm extends Model
{
    public $name;
    public $email;
    public $message;

    /**

     * @inheritdoc

     */

    public function rules()
    {

        return [
            [['name', 'email','message'], 'required'],

            [['name', 'email'], 'safe'],

            ['email', 'email'],

        ];

    }

    /**

     * @inheritdoc

     */

    public function attributeLabels()

    {

        return [

          //  'verifyCode' => Yii::t('app', 'Verification Code'),

          /*  'name' => 'Name',

            'email' => 'Email',

            'enquiry'=>'Subject',*/

        ];

    }



    /**

     * Sends an email to the specified email address using the information collected by this model.

     *

     * @param string $email the target email address

     * @return bool whether the email was sent

     */

    public function sendEmail($model)
    {
        $message = Yii::$app
            ->mailer
            ->compose(
                ['html' => 'contact', 'text' => 'contact'],
                ['model' => $model]
            )
            ->setFrom([Yii::$app->params['adminEmail'] => 'Contact'])
            ->setTo(Yii::$app->basic->emailto('email'))
            ->setSubject('Web Site' . 'Contact');
        $message->send();
        return $message;
    }

}

