<?php
    namespace backend\models;
   
    use Yii;
    use yii\base\Model;
    use common\models\User;
   
    class Passwordreset extends Model{
        public $oldpass;
        public $newpass;
        public $repeatnewpass;
        public $userid;
       
        public function rules(){
            return [
                [['oldpass','newpass','repeatnewpass'],'required'],
                [['userid'],'safe'],
                ['oldpass','findPasswords'],
               // ['oldpass','oldpass'],
                //['newpass','repeatpass'],
                ['repeatnewpass','compare','compareAttribute'=>'newpass'],
            ];
        }
    public function findPasswords($attribute, $params)
    {
        if (!$this->hasErrors()) {
            if($this->userid==null):
                $user = User::findOne(Yii::$app->user->identity->id);
            else:
                $user = User::findOne($this->userid);
            endif;
            if (!$user->validatePassword($this->oldpass)) {
                $this->addError($attribute, 'Old password is incorrect');
            }
        }
    }
    public function oldpass($attribute, $params)
    {
        if($this->oldpass!=null && $this->newpass==''){
            $this->addError('newpass', 'New password cannot be blank.');
        }
    }
    public function repeatpass($attribute, $params)
    {
        if($this->newpass!=null && $this->repeatnewpass==''){
            $this->addError('repeatnewpass', 'Repeat New Password cannot be blank.');
        }
    }

    public function attributeLabels(){
        return [
            'oldpass'=>'Old Password',
            'newpass'=>'New Password',
            'repeatnewpass'=>'Repeat New Password',
        ];
    }
    } 