<?php include('common/header.php'); ?>

<?php
require_once "common/Queries.php";
$q = new Queries();
function firstCategoryWithPackages(Queries $q, int $mainCatId): ?int {
    $subs = $q->getSubCategories($mainCatId);
    if (!$subs) return null;

    foreach ($subs as $sub) {
      
        $pk = $q->getPackagesByCategory($sub['id']);
        if (!empty($pk)) {
            return (int)$sub['id'];
        }
        $children = $q->getSubCategories($sub['id']);
        foreach ($children as $child) {
            $pkc = $q->getPackagesByCategory($child['id']);
            if (!empty($pkc)) {
                return (int)$child['id'];
            }
        }
    }
    return null;
}

$mainCatId    = isset($_GET["main"]) ? (int)$_GET["main"] : null;
$currentCatId = isset($_GET["id"])   ? (int)$_GET["id"]   : null;

$mainCategories = $q->getMainCategories();

if (empty($mainCategories)) {
    ?>
    <section class="banner-inner m-3">
      <div class="overlay position-absolute start-0 bottom-0 end-0 pb-5 mb-5 text-white z-3">
        <div class="container">
          <div class="d-flex">
            <div class="flex-grow-1">
              <div class="display-4 fw-bolder">Our Services</div>
            </div>
          </div>
        </div>
      </div>
      <img src="images/banner-service.jpg" width="1889" height="332" alt="banner" class="object-fit-cover img-fluid d-block">
    </section>
    <div class="container py-5">
      <div class="alert alert-warning">
        No categories configured yet.
      </div>
    </div>
    <?php include('common/footer.php'); exit; }
    
if (!$mainCatId) {
    $mainCatId = (int)$mainCategories[0]['id'];
}

$subCategories = $q->getSubCategories($mainCatId);

if (!$currentCatId) {
    $currentCatId = firstCategoryWithPackages($q, $mainCatId);
    if (!$currentCatId && !empty($subCategories)) {
        $currentCatId = (int)$subCategories[0]['id'];
    }
}

$currentCategory = $currentCatId ? $q->getCategory($currentCatId) : null;

$mainCategoryObj = $q->getCategory($mainCatId);
$currentTitle = $currentCategory['name'] ?? ($mainCategoryObj['name'] ?? 'Services');

?>

<section class="banner-inner m-3">
  <div class="overlay position-absolute start-0 bottom-0 end-0 pb-5 mb-5 text-white z-3">
    <div class="container">
      <div class="d-flex">
        <div class="flex-grow-1">
          <div class="display-4 fw-bolder">Our Services</div>
        </div>
        <div class="flex-fixed">
          <div class="d-flex flex-column">
            <p>How can we help?</p>
            <div class="d-flex rounded align-items-center bg-white px-3 search py-1">
              <i class="ri-search-line h4 m-0 text-secondary"></i>
              <input type="search" class="form-control w-100 border-0" placeholder="Find Products ">
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <img src="images/banner-service.jpg" width="1889" height="332" alt="banner" class="object-fit-cover img-fluid d-block">
</section>

<div class="content-wraper">

  <div class="pb-4">
    <div class="service-selector">
      <ul>
        <?php foreach ($mainCategories as $main): ?>
          <li class="<?= ((int)$main['id'] === (int)$mainCatId) ? 'active' : '' ?>">
            <a href="services.php?main=<?= (int)$main['id'] ?>">
              <img src="<?= $main['icon'] ?>" width="24" height="24" class="icon" alt="<?= htmlspecialchars($main['name']) ?>">
              <?= htmlspecialchars($main['name']) ?>
            </a>
          </li>
        <?php endforeach; ?>
      </ul>
    </div>
  </div>

  <div class="container">
    <div class="d-lg-flex align-items-start service-wraper">
      <div class="service-nav open flex-shrink-0">
        <div class="nav-hed d-flex justify-content-between m-3">
          <h6 class="m-0 fw-bold">Select Categories</h6>
          <button class="togler p-0 border-0 bg-transparent" id="navToggler">
            <div class="span-1"></div>
            <div class="span-2"></div>
          </button>
        </div>

        <div class="service-nav-content" data-simplebar>
          <div class="accordion" id="accordionExample">

            <?php if (!empty($subCategories)): ?>
              <?php foreach ($subCategories as $sub): ?>
                <?php
                  $childCategories   = $q->getSubCategories($sub['id']);
                  $isParentOfCurrent = ($currentCategory && (int)$currentCategory['parent'] === (int)$sub['id']);
                  $open      = ( ($currentCatId && (int)$currentCatId === (int)$sub['id']) || $isParentOfCurrent ) ? 'show' : '';
                  $collapsed = $open ? '' : 'collapsed';
                ?>
                <div class="accordion-item">
                  <h2 class="accordion-header" id="heading<?= (int)$sub['id'] ?>">
                    <button class="accordion-button <?= $collapsed ?>"
                            type="button"
                            data-bs-toggle="collapse"
                            data-bs-target="#collapse<?= (int)$sub['id'] ?>">
                      <?= htmlspecialchars($sub['name']) ?>
                    </button>
                  </h2>

                  <div id="collapse<?= (int)$sub['id'] ?>" class="accordion-collapse collapse <?= $open ?>"
                       data-bs-parent="#accordionExample">
                    <div class="accordion-body">
                      <ul class="sub-nav">
                        <?php if (!empty($childCategories)): ?>
                          <?php foreach ($childCategories as $child): ?>
                            <li>
                              <a href="services.php?main=<?= (int)$mainCatId ?>&id=<?= (int)$child['id'] ?>"
                                 class="<?= ($currentCatId && (int)$currentCatId === (int)$child['id']) ? 'active' : '' ?>">
                                <?= htmlspecialchars($child['name']) ?>
                              </a>
                            </li>
                          <?php endforeach; ?>
                        <?php else: ?>
                        
                          <li>
                            <a href="services.php?main=<?= (int)$mainCatId ?>&id=<?= (int)$sub['id'] ?>"
                               class="<?= ($currentCatId && (int)$currentCatId === (int)$sub['id']) ? 'active' : '' ?>">
                              <?= htmlspecialchars($sub['name']) ?>
                            </a>
                          </li>
                        <?php endif; ?>
                      </ul>
                    </div>
                  </div>
                </div>
              <?php endforeach; ?>
            <?php else: ?>
              <div class="p-3 text-muted">No subcategories under this main category.</div>
            <?php endif; ?>

          </div>
        </div>
      </div>
      <?php
        $packages = $currentCatId ? $q->getPackagesByCategory($currentCatId) : [];
        if (empty($packages)) {
            $fallback = $q->getPackagesByCategory($mainCatId);
            if (!empty($fallback)) {
                $packages = $fallback;
                $currentTitle = $currentTitle . ' (showing related packages)';
            }
        }
      ?>

      <div class="flex-grow-1 min-vw-0 pt-4 pt-lg-0 ps-4">
        <div class="pb-4 pb-lg-5">
          <div class="display-6 fw-bolder"><?= htmlspecialchars($currentTitle) ?></div>
          Select your desired resource to see the pricing
        </div>

        <?php if (!empty($packages)): ?>
          <div class="service-slider">
            <div class="swiper swiper-news max-w-100">
              <div class="swiper-wrapper">

                <?php foreach ($packages as $i => $pkg): ?>
                  <div class="swiper-slide">
                    <div class="service-item recomended">
                      <?php if ($i == 0): ?>
                        <div class="position-absolute text-center start-0 end-0 top-0 pt-2 text-uppercase text-white small">
                          recommended
                        </div>
                      <?php endif; ?>
                      <div class="inner p-4 position-relative">
                        <div class="position-absolute end-0 top-0 pt-3 pe-3">
                          <input type="checkbox" class="custom-check">
                        </div>
                        <div class="pt-5 text-center">
                          <div class="h2 fw-bolder"><?= htmlspecialchars($pkg['name']) ?></div>
                          <p class="small"><?= htmlspecialchars($pkg['subtitle'] ?? '') ?></p>

                          <?php if (!is_null($pkg['setup_fee']) && $pkg['setup_fee'] !== ''): ?>
                            <div class="d-flex align-items-center justify-content-center gap-1 mb">
                              <div class="badge text-black"><?= htmlspecialchars($pkg['setup_fee']) ?> Setup Fee</div>
                            </div>
                          <?php endif; ?>

                          <div class="d-flex align-items-center justify-content-center gap-1 pb-5">
                            <span class="fs-5 fw-bolder">
                              <?= htmlspecialchars($pkg['special_price']) ?> <?= htmlspecialchars($pkg['currency'] ?? 'USD') ?>
                            </span>
                            &nbsp;/ month
                            <?php if (!is_null($pkg['price']) && $pkg['price'] !== ''): ?>
                              <div class="text-black ms-2">
                                <del><?= htmlspecialchars($pkg['price']) ?> <?= htmlspecialchars($pkg['currency'] ?? 'USD') ?></del>
                              </div>
                            <?php endif; ?>
                          </div>

                          <a href="<?= htmlspecialchars($pkg['url'] ?? '#') ?>" class="btn btn-block w-100 btn-dark btn-lg">Order Now</a>

                          <?= $pkg['description'] ?>
                        </div>
                      </div>
                    </div>
                  </div>
                <?php endforeach; ?>

              </div>
            </div>
          </div>
        <?php else: ?>
          <div class="alert alert-info">No packages for this category.</div>
        <?php endif; ?>

      </div>

    </div>
  </div>


    <section class="pt-5 pt-lg-6 pt-xl-7">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <div class="section-hd text-center">
            <h3 class="fw-bolder" data-aos="fade-up" data-aos-delay="100" data-aos-duration="1500">Cloud Server Features</h3>
            <h5 data-aos="fade-up" data-aos-delay="100" data-aos-duration="1500">See all features if you purchase a cloud server</h5>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-12 col-md-6 col-lg-4 col-xl-3">
          <div class="service-feat-item" data-aos="fade-up" data-aos-delay="100" data-aos-duration="1500">
            <div class="feat-icon">
              <img src="images/service-feature-icon-01.png" alt="Image">
            </div>
            <div class="feat-body">
              <h3>Buy & Provision <br /> in minutes</h3>
            </div>
          </div>
        </div>
        
      </div>
    </div>
  </section>    

</div>

<?php include('common/footer.php'); ?>
